/* 
DATE: August 18, 2009
PURPOSE: Strip merged HRS cognition set down to needed variables with better names
TAKES IN: HRS_Cognitive_Measures
PUTS OUT: HRS_Cognitive_Measures(polished)
*/

// SETTINGS:
local log_p = "trude"
local latex_p = "false"
local reset_p = "true"

// RESET:
if "`reset_p'" == "true" {
	clear
	set mem 150m
	// set maxvar 7000
}

// NAMES:
local dir "/Users/Bowen/Documents/Laibson/HRS/Cognition Files/"
local lfilename = "Rename variables" // log name
local tfilename "" // tex name
local usefile "HRS_Cognitive_Measures_(raw)"

// PRELIMINARIES:
set more off
local time_now = substr(c(current_date),4,3) + substr(c(current_date),1,2) + " | " + subinstr(substr(c(current_time),1,5),":","-",1)
timer clear
timer on 47

// LOG:
if "`log_p'" == "true" {
	capture log close
	set logtype text
	log using "`dir'Logs/`lfilename' (`time_now').txt", replace
}

// LATEX:
if "`latex_p'" == "true" {
	capture: erase "`dir'`tfilename'.tex"
	capture file close tfile
	file open tfile using "`dir'`tfilename'.tex", write replace
	#delimit ;
	file write tfile 
		"\documentclass[11pt]{article}" _n
		"\usepackage{graphicx}" _n(2)
		"\begin{document}" _n(2)
		"\title{}" _n 
		"\author{Kyle Chauvin}" _n 
		"\maketitle" _n(2)
		"\newpage" _n(2); 	
	#delimit cr
}

//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ 

use "`dir'`usefile'"

rename HHID hhid
rename PN pn

local wave92 "1"
local wave93 "1"
local wave94 "2"
local wave95 "2"
local wave96 "3"
local wave98 "4"
local wave00 "5"
local wave02 "6"
local wave04 "7"
local wave06 "8"

local keep_vars "hhid pn"



// TICS Score:

// 1993

rename TICSR tics1

// 1995

rename D1340 tics2

// 1996

rename E1340 tics3

// 1998

rename F1677 tics4

// 2000

rename G1852 tics5

// 2002
rename HD170 tics6
* correct for cases where all but the count-down variable were missing
replace tics6 = . if tics6 == 2 & HD124 == 1 & HD151 == .

// 2004

rename JD170 tics7

// 2006

rename KD170 tics8

forvalues n = 1 / 8 {
	local keep_vars "`keep_vars' tics`n'"
}


gen first93 = V379 == 1 if V379 < .
gen second93 = V379 == 2 if V379 < .
* V379 is count back from 20: 1 = first try, 2 = second

local ticsvars1 V373 V374 V375 V376 first93 second93 V380 V381 V382 V383

local ticsvars2 D1179 D1180 D1181 D1182 D1205 D1228 D1301 D1302 D1303 D1304

local ticsvars3 E1179 E1180 E1181 E1182 E1205 E1228 E1301 E1302 E1303 E1304

local ticsvars4 F1645 F1646 F1647 F1648 F1535 F1558 F1649 F1650 F1651 F1652

local ticsvars5 G1820 G1821 G1822 G1823 G1710 G1733 G1824 G1825 G1826 G1827

local ticsvars6 HD151 HD152 HD153 HD154 HD124 HD129 HD155 HD156 HD157 HD158

local ticsvars7 JD151 JD152 JD153 JD154 JD124 JD129 JD155 JD156 JD157 JD158

local ticsvars8 KD151 KD152 KD153 KD154 KD124 KD129 KD155 KD156 KD157 KD158

* month day year day/week 20-1st 20-2nd cut-paper cactus president vice

forvalues n = 1 / 8 {
	forvalues x = 1 / 10 {
		local temp : word `x' of `ticsvars`n''
		gen tics`x'_`n' = `temp' == 1 if `temp' < .
		local keep_vars "`keep_vars' tics`x'_`n'"
	}
	replace tics6_`n' = 0 if tics6_`n' == .
	replace tics5_`n' = (tics5_`n' * 2) + tics6_`n'
}

forvalues y = 1 / 8 {
	local binlist ""
	foreach var in `ticsvars`y'' {
		gen bin`var' = `var' == 1 if `var' < .
		local binlist "`binlist' bin`var'"
	}
	local firstcount : word 5 of `binlist'
	local secondcount : word 6 of `binlist'
	replace `firstcount' = `firstcount' * 2
	replace `secondcount' = 0 if `secondcount' == .
	egen mytics`y' = rowtotal(`binlist')
	egen miss`y' = rowmiss(`binlist')
	replace mytics`y' = . if miss`y' > 0

	local keep_vars "`keep_vars' mytics`y'"
}

*sum tics* mytics*

forvalues n = 4 / 4 {
	*list `ticsvars`n'' tics`n' mytics`n' if tics`n' != mytics`n' & _n < 10000
}


// Numeracy:

// Chance get disease:

	/* If the chance of getting a disease is 10 percent, how many people out of 1,000 
	would be expected to get the disease? */

forvalues n = 1 / 5 {
	gen cgdisease`n' = .
}

// 2002

gen cgdisease6 = HD178 == 100 if HD178 < 9998
replace cgdisease6 = . if HD178 == 9999
replace cgdisease6 = 0 if HD178 == 9998

// 2004

gen cgdisease7 = JD178 == 100 if JD178 < 9999998
replace cgdisease7 = . if JD178 == 9999999
replace cgdisease7 = 0 if JD178 == 9999998

// 2006

gen cgdisease8 = KD178 == 100 if KD178 < 9999999998
replace cgdisease8 = . if KD178 == 9999999999
replace cgdisease8 = 0 if KD178 == 9999999998

// Lottery five ways:

forvalues n = 1 / 5 {
	gen lottery`n' = .
}

// 2002

gen lottery6 = HD179 == 400000 if HD179 < 999999998
replace lottery6 = . if HD179 == 999999999
replace lottery6 = 0 if HD179 == 999999998

// 2004

gen lottery7 = JD179 == 400000 if JD179 < 999999998
replace lottery7 = . if JD179 == 999999999
replace lottery7 = 0 if JD179 == 999999998

// 2006

gen lottery8 = KD179 == 400000 if KD179 < 9999999998
replace lottery8 = . if KD179 == 9999999999
replace lottery8 = 0 if KD179 == 9999999998

// Interest on savings:

forvalues n = 1 / 5 {
	gen interest`n' = .
}

// 2002

gen interest6 = HD180 == 242 if HD180 < 999999998
replace interest6 = . if HD180 == 999999998
replace interest6 = 0 if HD180 == 999999999

// 2004

gen interest7 = JD180 == 242 if JD180 < 99999999998
replace interest7 = . if JD180 == 99999999998
replace interest7 = 0 if JD180 == 99999999999

// 2006

gen interest8 = KD180 == 242 if KD180 < 9999999998
replace interest8 = . if KD180 == 9999999999
replace interest8 = 0 if KD180 == 9999999998

forvalues n = 1 / 8 {
	local keep_vars "`keep_vars' cgdisease`n' lottery`n' interest`n'"
}

// Immediate Word Recall:

	/* Interviewer lists off ten nouns to the subject, then asks the subject to
	repeat as many as possible from the list. Recorded here is the total number
	of words the subject was able to correctly recall. */

// 1993

gen immwords1 = IMMWORDC

// 1995 -- 2006 list stubs:

local wstub95 "D1174M"
local wstub96 "E1174M"
local wstub98 "F1491M"
local wstub00 "G1666M"
local wstub02 "HD182M"
local wstub04 "JD182M"
local wstub06 "KD182M"

// 1995 -- 2006 create score variables:

foreach year in 95 96 98 "00" "02" "04" "06" {
	foreach var of varlist `wstub`year''* {
		replace `var' = .r if `var' == 99
		replace `var' = . if `var' > 40
	}
	egen immwords`wave`year'' = rownonmiss(`wstub`year''*)
	replace immwords`wave`year'' = . if `wstub`year''1 == .r | `wstub`year''1 == .
}

forvalues n = 1 / 8 {
	local keep_vars "`keep_vars' immwords`n'"
}



// Delayed Word Recall:

	/* Interviewer returns to the lists of ten nouns that were read off to the 
	subject earlier, then asks the subject to	repeat as many as possible from 
	the list. Recorded here is the total number of words the subject was able to 
	correctly recall. */

// 1993

gen delwords1 = DELWORDC

// 1995 -- 2006 list stubs:

local wstub95 "D1314M"
local wstub96 "E1314M"
local wstub98 "F1640M"
local wstub00 "G1815M"
local wstub02 "HD183M"
local wstub04 "JD183M"
local wstub06 "KD183M"

// 1995 -- 2006 create score variables:

foreach year in 95 96 98 "00" "02" "04" "06" {
	foreach var of varlist `wstub`year''* {
		replace `var' = .r if `var' == 99
		replace `var' = . if `var' > 40
	}
	egen delwords`wave`year'' = rownonmiss(`wstub`year''*)
	replace delwords`wave`year'' = . if `wstub`year''1 == .r | `wstub`year''1 == .
}

replace JD183M12 = . if JD183M12 == JD183M11

forvalues n = 1 / 8 {
	local keep_vars "`keep_vars' delwords`n'"
}


// serial SEVENS:

	/* First take all individual question variables and convert them into binary 
	1 = correct, 0 = wrong / don't know, also with 2 = refused. Then for each
	year go through and set the year var to the highest individual question
	number (n = 1 to 5) for which a correct response is marked. */


// 1993 convert to binary correct:

forvalues n = 4 / 8 {
	
	local var "V38`n'"
	local n_3 = `n' - 3
	local nvar "serial7s1_`n_3'"
	local correct = 100 - (`n_3')*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if (`var' != `correct' & `var' < .) | `var' == .d
	replace `nvar' = 2 if `var' == .r
}

// 1995 convert to binary correct:

forvalues n = 5 / 9 {
	
	local var "D130`n'"
	local n_4 = `n' - 4
	local nvar "serial7s2_`n_4'"
	local correct = 100 - (`n_4')*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if `var' != `correct' & `var' < 999
	replace `nvar' = 2 if `var' == 999
}

// 1996 convert to binary correct:

forvalues n = 5 / 9 {
	
	local var "E130`n'"
	local n_4 = `n' - 4
	local nvar "serial7s3_`n_4'"
	local correct = 100 - (`n_4')*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if `var' != `correct' & `var' < 999
	replace `nvar' = 2 if `var' == 999
}

// 1998 convert to binary correct:

forvalues n = 1 / 5 {
	
	local var "F163`n'"
	local nvar "serial7s4_`n'"
	local correct = 100 - `n'*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if `var' != `correct' & `var' < 999
	replace `nvar' = 2 if `var' == 999
}

// 2000 convert to binary correct:

forvalues n = 6 / 10 {
	
	local m = string(`n', "%02.0f")
	
	di "n is [`n'], m is [`m']"
	
	local var "G18`m'"
	local n_5 = `n' - 5
	local nvar "serial7s5_`n_5'"
	local correct = 100 - (`n_5')*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if `var' != `correct' & `var' < 999
	replace `nvar' = 2 if `var' == 999
}

// 2002 convert to binary correct:

forvalues n = 2 / 6 {
	
	local var "HD14`n'"
	local n_1 = `n' - 1
	local nvar "serial7s6_`n_1'"
	local correct = 100 - (`n_1')*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if `var' != `correct' & `var' < 999
	replace `nvar' = 2 if `var' == 999
}

// 2004 convert to binary correct:

forvalues n = 2 / 6 {
	
	local var "JD14`n'"
	local n_1 = `n' - 1
	local nvar "serial7s7_`n_1'"
	local correct = 100 - (`n_1')*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if `var' != `correct' & `var' < 999
	replace `nvar' = 2 if `var' == 999
}

// 2006 convert to binary correct:	

forvalues n = 2 / 6 {
	
	local var "KD14`n'"
	local n_1 = `n' - 1
	local nvar "serial7s8_`n_1'"
	local correct = 100 - (`n_1')*7
	
	gen `nvar' = 1 if `var' == `correct'
	replace `nvar' = 0 if `var' != `correct' & `var' < 999
	replace `nvar' = 2 if `var' == 999
}

// Convert binary correct vars to year sum vars:

forvalues y = 1 / 8 {
	gen serial7s`y' = serial7s`y'_1 if serial7s`y'_1 < 2
	replace serial7s`y' = .r if serial7s`y'_1 == 2
	forvalues n = 2 / 5 {
		replace serial7s`y' = `n' if serial7s`y'_`n' == 1
	}	
	local keep_vars "`keep_vars' serial7s`y'"
}

// Summary:

forvalues n = 1 / 8 {
	gen summary`n' = immwords`n' + delwords`n' + tics`n' + serial7s`n'
	local keep_vars "`keep_vars' summary`n'"
	*sum summary`n' immwords`n' delwords`n' tics`n' serial7s`n'
}


keep `keep_vars'
save "`dir'HRS_Cognitive_Measures_(polished)", replace

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

if "`latex_p'" == "true" {
	file write tfile "\end{document}" _n
	file close tfile
	shell latex "`dir'`tfilename'.tex" "`dir'../"

	***Erasing unnecessary files
	foreach extension in "aux" "log" {
		capture: erase "`dir'`tfilename'.`extension'"
	}
}

timer off 47
timer list 47
capture log close

exit



sum `ticsvars02' `ticsvars04' tics02 tics04 tics06 HD170 JD170 KD170 // if HD170 == 2

foreach stub in "KD183M" {
	forvalues a = 1 / 13 {
		local a_1 = `a' + 1
		forvalues b = `a_1' / 13 {
			gen same`a'`b' = `stub'`a' == `stub'`b' & `stub'`a' != .
		}
	}

	egen problem`stub' = rowtotal(same*)
	tab problem`stub'
	drop same*
	
	list `stub'* if problem`stub' == 1
}